  //@author: dottore
  //@description: evaluates Zdepth using Near, Focus, Far parameters.
  //@tags: Zdepth
  //@credits: ShaderX3 book (chapter 4.4 ; Improved Depth-of-Field Rendering; Thorsten Scheuermann and Natalya Tararchuk)


// -------------------------------------------------------------------------------------------------------------------------------------
// PARAMETERS:
// -------------------------------------------------------------------------------------------------------------------------------------

//transforms
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 tW: WORLD;
float4x4 tVP: VIEWPROJECTION;

float dNear <string uiname="d Near";>  = -1;
float dFocus <string uiname="d Focus";>  = 0;
float dFar  <string uiname="d Far";>  = 2;
float clampFar  <string uiname="Clamp Far";>  = .9;
float3 camPos  <string uiname="XYZ Camera Position";> ;


// -------------------------------------------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// -------------------------------------------------------------------------------------------------------------------------------------

struct VS_OUTPUT
{
    float4 Pos  : POSITION;
    float4 col : COLOR;
};

VS_OUTPUT VS(
    float4 Pos  : POSITION)
{
    //inititalize all fields of output struct with 1
    VS_OUTPUT Out = (VS_OUTPUT)1;

    Pos = mul(Pos, tW);

     float depth = distance(Pos,camPos);

     if    (depth < dFocus)
     {
           depth = (depth - dNear)/(dFocus - dNear)/2;
     }

     else
     {
           depth = (depth-dFocus)/(dFar - dFocus)/2 + 0.5;
           //OPTIONAL:
           depth = clamp (depth, 0, clampFar) ;
     }

     Out.Pos = mul(Pos, tVP);
     Out.col.rgb = depth;

    return Out;
}

VS_OUTPUT VS2(
    float4 Pos  : POSITION)
{
    //inititalize all fields of output struct with 1
    VS_OUTPUT Out = (VS_OUTPUT)1;
    
    Out.Pos = mul(Pos, tWVP);

     float depth = Out.Pos.z;
     
     if    (depth < dFocus)
     {
           depth = (depth - dNear)/(dFocus - dNear)/2;
     }
        
     else
     {
           depth = (depth-dFocus)/(dFar - dFocus)/2 + 0.5;
           //OPTIONAL:
           depth = clamp (depth, 0, clampFar) ;
     }

     Out.col.rgb = depth;

    return Out;
}


// -------------------------------------------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// -------------------------------------------------------------------------------------------------------------------------------------

float4 PS(VS_OUTPUT In): COLOR
{
    return In.col;
}

// -------------------------------------------------------------------------------------------------------------------------------------
// TECHNIQUES:
// -------------------------------------------------------------------------------------------------------------------------------------

technique DistanceCameraDepth
{
    pass P0
    {
        VertexShader = compile vs_1_0 VS();
        PixelShader  = compile ps_1_0 PS();
    }
}

technique ViewMatrixDepth
{
    pass P0
    {
        VertexShader = compile vs_1_0 VS2();
        PixelShader  = compile ps_1_0 PS();
    }
}
